
<?php if(!empty($flightData) && isset($flightData) && isset($flightData['departure'])): ?>
    <?php
        $logo = $flightData['airline'] ?? 'default';

        $departure = $flightData['departure'] ?? null;
        $originCode = $departure['departure']['code'] ?? '';
        $destinationCode = $departure['arrival']['code'] ?? '';
        $depTime = $departure['departure']['time'] ?? '';
        $arrTime = $departure['arrival']['time'] ?? '';
        $depTimeDiff = $departure['duration'] ?? '';
        $isConnected = $departure['isConnected'] === 'true';
        $stopCount = count($departure['segments']) - 1;

        $hasReturn = isset($flightData['return']);
        if ($hasReturn) {
            $return = $flightData['return'];
            $returnOriginCode = $return['departure']['code'] ?? '';
            $returnDestinationCode = $return['arrival']['code'] ?? '';
            $returnDepTime = $return['departure']['time'] ?? '';
            $returnArrTime = $return['arrival']['time'] ?? '';
            $returnTimeDiff = $return['duration'] ?? '';
            $returnIsConnected = $return['isConnected'] === 'true';
            $returnStopCount = count($return['segments']) - 1;
        }

        $depDate = $departure['departure']['date'] ?? '';
    ?>
    <div class="steps">
        <h4>Your Booking</h4>
        <div class="sugge-tab sugge-tab-tickes">
            <div class="flex1">
            <div class="emri w-25">
                <img src="<?php echo e(asset('assets/images/logos/modal/' . $logo . '.png')); ?>" alt="<?php echo e(strtoupper($logo)); ?>">
            </div>   
            <div class="der-time der-time-setps">
                <ul>
                    <li><h2><?php echo e($depTime); ?></h2></li>
                    <li><div class="stays"><p><?php echo e($depTimeDiff); ?></p></div></li>
                    <li><div class="tims"><h2><?php echo e($arrTime); ?></h2></div></li>
                </ul>
                <div class="citys">
                    <div class="cit">
                        <ul>
                            <li><p><?php echo e($originCode); ?></p></li>
                            <li><p>-</p></li>
                            <?php if($isConnected): ?>
                                <li><p><?php echo e($stopCount); ?> <?php echo e($stopCount > 1 ? 'Stops' : 'Stop'); ?></p></li>
                            <?php else: ?>
                                <li><p>Nonstop</p></li>
                            <?php endif; ?>
                            <li><p>-</p></li>
                            <li><p><?php echo e($destinationCode); ?></p></li>
                        </ul>
                    </div>
                </div>
            </div>
            </div>
        </div>
        <?php if($hasReturn): ?>
            <div class="sugge-tab sugge-tab-tickes mt-2">
                <div class="flex1">
                    <div class="emri w-25">
                    <img src="<?php echo e(asset('assets/images/logos/modal/' . $logo . '.png')); ?>" alt="<?php echo e(strtoupper($logo)); ?>">
                    </div>   
                    <div class="der-time der-time-setps">
                    <ul>
                        <li><h2><?php echo e($returnDepTime); ?></h2></li>
                        <li><div class="stays"><p><?php echo e($returnTimeDiff); ?></p></div></li>
                        <li><div class="tims"><h2><?php echo e($returnArrTime); ?></h2></div></li>
                    </ul>
                    <div class="citys">
                        <div class="cit">
                            <ul>
                                <li><p><?php echo e($returnOriginCode); ?></p></li>
                                <li><p>-</p></li>
                                <?php if($returnIsConnected): ?>
                                    <li><p><?php echo e($returnStopCount); ?> <?php echo e($returnStopCount > 1 ? 'Stops' : 'Stop'); ?></p></li>
                                <?php else: ?>
                                    <li><p>Nonstop</p></li>
                                <?php endif; ?>
                                <li><p>-</p></li>
                                <li><p><?php echo e($returnDestinationCode); ?></p></li>
                            </ul>
                        </div>
                    </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
<?php endif; ?>
<?php /**PATH D:\wamp64\www\travelandtours\resources\views/components/flight-and-price-ticket.blade.php ENDPATH**/ ?>