<!DOCTYPE html>

<html lang="en">

<head>
  <meta charset="utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=0" />

  <title><?php echo $__env->yieldContent('title'); ?> | EDESTINATIONS</title>
  <meta name="description" content="<?php echo e(config('variables.metaDescription') ?? ''); ?>" />
  <meta name="keywords" content="<?php echo e(config('variables.metaKeyword') ?? ''); ?>">

  <!-- Favicon -->
  <link rel="shortcut icon" href="<?php echo e(url('assets/images/favicon.png')); ?>" type="image/x-icon">
  

  <!-- Include Styles -->
  <link rel="stylesheet" href="<?php echo e(url('assets/css/layout.css')); ?>">
  <link rel="stylesheet" href="<?php echo e(url('assets/css/style.css')); ?>">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.1.0/css/all.min.css" integrity="sha512-10/jx2EXwxxWqCLX/hHth/vu2KY3jCF70dCQB8TSgNjbCVAC/8vai53GfMDrO2Emgwccf2pJqxct9ehpzG+MTw==" crossorigin="anonymous" referrerpolicy="no-referrer" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.7.2/css/all.min.css" integrity="sha512-Evv84Mr4kqVGRNSgIGL/F/aIDqQb7xQ2vcrdIwxfjThSH8CSR7PBEakCr51Ck+w+/U6swU2Im1vVX0SVk9ABhg==" crossorigin="anonymous" referrerpolicy="no-referrer" />
  <link rel="icon" href="/favicon.ico" type="image/x-icon">
  <link href="https://fonts.googleapis.com/css?family=Mulish:200,300,regular,500,600,700,800,900,200italic,300italic,italic,500italic,600italic,700italic,800italic,900italic" rel="stylesheet" />
  <link href="https://fonts.googleapis.com/css?family=Poppins:100,100italic,200,200italic,300,300italic,regular,italic,500,500italic,600,600italic,700,700italic,800,800italic,900,900italic" rel="stylesheet" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/flag-icon-css/3.5.0/css/flag-icon.min.css" />
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <script src="<?php echo e(url('assets/js/jquery.js')); ?>"></script>
  <?php echo $__env->yieldContent('style'); ?>
</head>

<body>
  <?php echo $__env->make('home/layouts/navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <?php if(session('message')): ?>
    <script>
      $(document).ready(function() {
        _alert("<?php echo e(session('message')); ?>", "<?php echo e(session('status')); ?>");
      });
    </script>
  <?php endif; ?>
  <?php if($errors->any()): ?>
    <script>
      $(document).ready(function () {
        _alert("<?php echo e($errors->first()); ?>", "error");
      });
    </script>
  <?php endif; ?>
  <!-- Layout Content -->
  <?php echo $__env->yieldContent('content'); ?>
  <!--/ Layout Content -->

  <!-- Include Scripts -->
  <?php echo $__env->make('combine/scripts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <?php echo $__env->make('home/layouts/footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <?php echo $__env->make('home/partials/scripts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <?php echo $__env->yieldContent('script'); ?>

</body>

</html><?php /**PATH D:\wamp64\www\destination-travel\resources\views/home/layouts/master.blade.php ENDPATH**/ ?>