<!DOCTYPE html>

<html lang="en">

<head>
  <meta charset="utf-8" />
  <meta http-equiv="X-UA-Compatible" content="IE=edge" />
  <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=0" />

  <title><?php echo $__env->yieldContent('title'); ?> | travelandtours</title>
  <meta name="description" content="<?php echo e(config('variables.metaDescription') ?? ''); ?>" />
  <meta name="keywords" content="<?php echo e(config('variables.metaKeyword') ?? ''); ?>">

  <!-- Favicon -->
  <link rel="shortcut icon" href="<?php echo e(url('assets/images/favicon.png')); ?>" type="image/x-icon">
  <link rel="icon" href="/favicon.ico" type="image/x-icon">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-4Q6Gf2aSP4eDXB8Miphtr37CMZZQ5oXLH2yaXMJ2w8e2ZtHTl7GptT4jmndRuHDT" crossorigin="anonymous">
  <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
  <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
  <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
  <script src="<?php echo e(url('assets/js/jquery.js')); ?>"></script>
  <link rel="stylesheet" href="<?php echo e(url('assets/admin/style.css')); ?>">
  <?php echo $__env->yieldContent('style'); ?>
  <style>
    input[type=number]::-webkit-inner-spin-button,input[type=number]::-webkit-outer-spin-button {-webkit-appearance: none;margin: 0;}
    input[type=number] {-moz-appearance: textfield;}
    #loader{width:100%;height:100%;display:flex;justify-content:center;align-items:center;background-color:rgba(0,0,0,0.5) !important;z-index:9999;position:fixed;top:0;left:0;overflow:hidden;transition:opacity 0.5s ease;}
    #loaderChild{width:30px;height:30px;border:5px solid #fff;border-top-color:#007bff;border-radius:50%;animation:spin 2s linear infinite;}
    .content {
      padding: 20px;
      height: calc(100vh - 60px);
    }
    header {
      position: sticky !important;
      top: 0;
      z-index: 1000;
      background-color: #f8f9fa;
      padding: 10px 20px;
      border-bottom: 1px solid #dee2e6;
    }
    #preloader {
      position: fixed;
      top: 0;
      left: 0;
      width: 100%;
      height: 100%;
      background-color: #fff;
      z-index: 9999;
    }
    #preloader .dual-ring {
      width: 40px;
      height: 40px;
      border: 4px solid #3498db;
      border-radius: 50%;
      border-top-color: transparent;
      animation: dual-ring 1.2s linear infinite;
    }
    @keyframes dual-ring {
      0% {
        transform: rotate(0deg);
      }
      100% {
        transform: rotate(360deg);
      }
    }

    header {

    }
  </style>
</head>

<body>
  <!-- Preloader -->
  <div id="preloader" class="d-none">
    <div data-loader="dual-ring"></div>
  </div>
  <!--/ Preloader -->
  <?php if(session('message')): ?>
    <script>
      $(document).ready(function() {
        _alert("<?php echo e(session('message')); ?>", "<?php echo e(session('status')); ?>");
      });
    </script>
  <?php endif; ?>
  <?php if(session('error')): ?>
    <script>
      $(document).ready(function() {
        _alert("<?php echo e(session('error')); ?>", "error");
      });
    </script>
  <?php endif; ?>
  <?php if($errors->any()): ?>
    <script>
      $(document).ready(function () {
        _alert("<?php echo e($errors->first()); ?>", "error");
      });
    </script>
  <?php endif; ?>
  <?php echo $__env->make('admin/layouts/navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <div class="content container-fluid">
  
  <?php if(session('message')): ?>
    <script>
      $(document).ready(function () {
        _alert("<?php echo e(session('message')); ?>", "<?php echo e(session('status')); ?>");
      });
    </script>
  <?php endif; ?>
    <!-- Layout Content -->
    <?php echo $__env->yieldContent('content'); ?>
    <!--/ Layout Content -->
  </div>

  <!-- Include Scripts -->
  
  <?php echo $__env->make('combine/scripts', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
  <script src="<?php echo e(url('assets/admin/script.js')); ?>"></script>
  <?php echo $__env->yieldContent('script'); ?>

</body>

</html><?php /**PATH D:\wamp64\www\travelandtours\resources\views/admin/layouts/master.blade.php ENDPATH**/ ?>