<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('cancel_responses', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('booking_id');
            $table->longText('xml_body');

            $table->foreign('booking_id')->references('id')->on('bookings')->onDelete('cascade');
            $table->softDeletes();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('cancel_responses');
    }
};
